// Insights Page Tour
$(document).ready(function() {
    if (localStorage.getItem('tourAtInsights') === '1') {
        localStorage.removeItem('tourAtInsights');
        setTimeout(startInsightsTour, 1500);
    }
});

function startInsightsTour() {
    showTourMsg(
        "🦈 Shark Investments",
        "Try clicking different shark names to see their investment patterns!",
        () => {
            $('.shark-buttons').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            setTimeout(promptHeatmap, 7000);
        }
    );
}

function promptHeatmap() {
    showTourMsg(
        "🔥 Deal Probability Heatmap",
        "Click 'Show Sample Size Heatmap' button to toggle the view!",
        () => {
            $('#heatmap').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            setTimeout(promptWordCloud, 7000);
        }
    );
}

function promptWordCloud() {
    showTourMsg(
        "☁️ Most Popular Industries",
        "Hover over different industry names to see detailed statistics!",
        () => {
            $('#wordcloud').get(0).scrollIntoView({ behavior: 'smooth', block: 'center' });
            setTimeout(promptTryIt, 8000);
        }
    );
}

function promptTryIt() {
    showTourMsg(
        "🚀 Try the Prediction Tool",
        "Ready to test your own pitch? Go back to the home page and click 'Try It'!",
        () => {
            localStorage.setItem('tourAtTry', '1');
            window.location.href = 'index.html#try';
        }
    );
}

function showTourMsg(title, msg, callback) {
    closeTourMsg();

    const popup = $('<div class="tour-popup"></div>');
    popup.attr('id', 'insightsTourPopup');
    popup.css({
        position: 'fixed',
        top: '50%',
        left: '50%',
        transform: 'translate(-50%, -50%)',
        zIndex: 10000
    });

    popup.html(`
        <h3>${title}</h3>
        <p>${msg}</p>
        <div class="tour-buttons">
            <button class="tour-btn tour-btn-secondary" onclick="skipInsightsTour()">Skip</button>
            <button class="tour-btn tour-btn-primary" onclick="nextInsightsStep()">Got It</button>
        </div>
    `);

    $('body').append(popup);

    let overlay = $('#insightsTourOverlay');
    if (overlay.length === 0) {
        overlay = $('<div class="tour-overlay active" id="insightsTourOverlay"></div>');
        $('body').append(overlay);
    } else {
        overlay.addClass('active');
    }

    window.nextInsightsStep = () => {
        closeTourMsg();
        if (callback) callback();
    };
}

function closeTourMsg() {
    $('#insightsTourPopup').remove();
    $('#insightsTourOverlay').removeClass('active');
}

function skipInsightsTour() {
    closeTourMsg();
    localStorage.setItem('tourCompleted', '1');
    localStorage.removeItem('tourAtInsights');
    localStorage.removeItem('tourAtTry');
}

window.skipInsightsTour = skipInsightsTour;
